package app.firezone.synk.network.Fragments;

import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.TrHistoryAdapter;
import app.firezone.synk.network.databinding.FragmentHistoryBinding;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.TransactionResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;


public class HistoryFragment extends Fragment {


    FragmentHistoryBinding binding;
    ArrayList<TransactionModel> list;
    TrHistoryAdapter adapter;
    long userId;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
       binding =    FragmentHistoryBinding.inflate(inflater, container, false);
       View view =  binding.getRoot();


        // Initialize RecyclerView
        LinearLayoutManager layoutManager = new LinearLayoutManager(getContext());
        binding.historyRecy.setLayoutManager(layoutManager);
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);

        // Get userId from SharedPrefManager
        userId = SharedPrefManager.getInstance(getContext()).getUserId();

        // API call to fetch transactions
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<TransactionResponse> call = myApi.fetchUserTransaction(userId);

        call.enqueue(new Callback<TransactionResponse>() {
            @Override
            public void onResponse(Call<TransactionResponse> call, Response<TransactionResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        ArrayList<TransactionModel> list = response.body().getTransactions();
                        if (!list.isEmpty()) {
                            adapter = new TrHistoryAdapter(getContext(), list);
                            binding.historyRecy.setAdapter(adapter);
                        } else {
                            // no transaction found
                        }
                    } else {
                        Toast.makeText(getContext(), response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(getContext(), "Failed to fetch transactions", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<TransactionResponse> call, Throwable t) {
                Toast.makeText(getContext(), "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });



        return  view;
    }






}